﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.OData;
using System.Web.OData.Routing;
using Microsoft.Xrm.Sdk;
using PpmsDataService.V1.Mappers;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;
using System.Net;
using System.Net.Http;
using Microsoft.Web.Http;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class ProviderSpecialtiesController : ODataController
    {
        [ODataRoute("ProviderSpecialties('{key}')")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderSpecialties =
                    context.ppms_providertaxonomySet.Where(i => i.ppms_codedspecialty.Equals(key));
                var ppmsProviderSpecialtiesList = ppmsProviderSpecialties.ToList();
                if (ppmsProviderSpecialtiesList.Any())
                {
                    //Map Provider Specialties
                    var providerSpecialties = await ProviderSpecialtyMap.MapProviderSpecialties(ppmsProviderSpecialtiesList, queryType, context);
                    return Request.CreateResponse(providerSpecialties);
                }
                var message = string.Format("Provider Specialty with Specialty Code: {0} not found", key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        //Look up Provider Specialties based on the Specialty Code and then return the related Provider       
        [ODataRoute("ProviderSpecialties('{key}')/Provider")]
        public async Task<HttpResponseMessage> GetProvider([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Find the Provider Specialties based on the coded specialty
                var ppmsProviderSpecialties =
                    context.ppms_providertaxonomySet.Where(i => i.ppms_codedspecialty.Equals(key));
                var ppmsProviderSpecialtiesList = ppmsProviderSpecialties.ToList();
                if (ppmsProviderSpecialtiesList.Any())
                {
                    //Retrieve and Return the related Providers
                    var ppmsProviderList = new List<Account> { };
                    foreach (var ppmsProviderSpecialty in ppmsProviderSpecialties)
                    {
                        var ppmsProvider =
                            context.AccountSet.FirstOrDefault(
                                i => i.Id == ppmsProviderSpecialty.ppms_ProviderId.Id);
                        ppmsProviderList.Add(ppmsProvider);
                    }
                    var providers =
                        await ProviderMap.MapProviders(ppmsProviderList, "None", context);
                    return Request.CreateResponse(providers);
                }
                var message = string.Format("Provider with Provider Specialty Code: {0} not found", key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        //Look up Provider Specialties based on the Specialty Code and then return the related Specialty       
        [ODataRoute("ProviderSpecialties('{key}')/Specialty")]
        public async Task<HttpResponseMessage> GetSpecialty([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Find the Provider Specialties based on the coded specialty
                var ppmsProviderSpecialties =
                    context.ppms_providertaxonomySet.Where(i => i.ppms_codedspecialty.Equals(key));
                var ppmsProviderSpecialtiesList = ppmsProviderSpecialties.ToList();
                if (ppmsProviderSpecialtiesList.Any())
                {
                    //Retrieve and Return the related Providers
                    var ppmsSpecialtyList = new List<ppms_taxonomy> { };
                    foreach (var ppmsProviderSpecialty in ppmsProviderSpecialties)
                    {
                        var ppmsSpecialty =
                            context.ppms_taxonomySet.FirstOrDefault(
                                i => i.Id == ppmsProviderSpecialty.ppms_TaxonomyId.Id);
                        ppmsSpecialtyList.Add(ppmsSpecialty);
                    }
                    var specialties =
                        await SpecialtyMap.MapSpecialties(ppmsSpecialtyList, "None", context);
                    return Request.CreateResponse(specialties);
                }
                var message = string.Format("Specialty with Provider Specialty Code: {0} not found", key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        /*
        [ODataRoute("ProviderSpecialties({key})/ProviderServices")]
        public async Task<HttpResponseMessage> GetProviderServices([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Find the Provider Specialties based on the coded specialty
                var ppmsProviderSpecialties =
                    context.ppms_providertaxonomySet.Where(i => i.ppms_codedspecialty.Equals(key));
                var ppmsProviderSpecialtiesList = ppmsProviderSpecialties.ToList();
                if (ppmsProviderSpecialtiesList.Any())
                {
                    //Retrieve and Return the related Provider Services    
                    var providerServices = new List<IQueryable<ProviderService>> {};
                    foreach (var ppmsProviderSpecialty in ppmsProviderSpecialties)
                    {
                        var ppmsProviderServicesList =
                            context.ppms_providerserviceSet.Where(
                                i => i.ppms_ProviderSpecialty.Id == ppmsProviderSpecialty.Id).ToList();
                        var provServices =
                            await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                        providerServices.Add(provServices);
                    }
                    return Request.CreateResponse(providerServices);
                }
                var message = string.Format(" with : {0} not found", key);
            }
        }
        

        [ODataRoute("ProviderSpecialties('{key}')/ProviderAgreements")]
        public async Task<HttpResponseMessage> GetProviderAgreements([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Find the Provider Specialties based on the coded specialty
                var ppmsProviderSpecialties =
                    context.ppms_providertaxonomySet.Where(i => i.ppms_codedspecialty.Equals(key));
                var ppmsProviderSpecialtiesList = ppmsProviderSpecialties.ToList();
                if (ppmsProviderSpecialtiesList.Any())
                {
                    //Retrieve and Return the related Provider Agreements    
                    var providerAgreements = new List<IQueryable<ProviderAgreement>> { };
                    foreach (var ppmsProviderSpecialty in ppmsProviderSpecialties)
                    {
                        var ppmsProviderAgreementsList =
                            context.ppms_provideragreementSet.Where(
                                i => i.ppms_Agreement.Id == ppmsProviderSpecialty.Id).ToList();
                        var provAgreements =
                            await ProviderAgreementsMap.MapProviderAgreements(ppmsProviderAgreementsList, "None", context);
                        providerAgreements.Add(provAgreements);
                    }
                    return Request.CreateResponse(providerAgreements);
                }
                var message = string.Format("Provider Agreements with Provider Specialty Code: {0} not found", key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }
        */

        [ODataRoute("ProviderSpecialties")]
        public async Task<HttpResponseMessage> Get()
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderSpecialties =
                        context.ppms_providertaxonomySet.Where(i => i.ppms_TaxonomyId != null && i.ppms_ProviderId != null).Take(50);
                var ppmsProviderSpecialtiesList = ppmsProviderSpecialties.ToList();
                if (ppmsProviderSpecialtiesList.Any())
                {
                    var providerSpecialties = await ProviderSpecialtyMap.MapProviderSpecialties(ppmsProviderSpecialtiesList, "None", context);
                    return Request.CreateResponse(providerSpecialties);
                }
            }
            var message = "Provider Specialties Not Found";
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }
    }
}